<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "Iniciando...<br>";

// Caminho do arquivo de configuração
$configFile = __DIR__ . '../config.ini';
echo "Arquivo de configuração: $configFile<br>";

// Verifica se o arquivo de configuração existe
if (!file_exists($configFile)) {
    die("Arquivo config.ini não encontrado: $configFile<br>");
}

// Carrega o arquivo de configuração
$ini = parse_ini_file($configFile, true);
if (!$ini) {
    die("Erro ao carregar o arquivo config.ini<br>");
}

echo "Arquivo de configuração carregado com sucesso!<br>";

// Recupera o parâmetro 'bd' passado na URL
$bd = isset($_GET['bd']) ? $_GET['bd'] : null;
echo "Base de dados recebida: $bd<br>";

// Verifica se a base de dados foi definida corretamente
if (!$bd || !isset($ini[$bd])) {
    die("Base de dados '$bd' não encontrada no arquivo de configuração.<br>");
}

echo "Base de dados '$bd' localizada no arquivo config.ini.<br>";

// Recupera as informações de conexão do arquivo INI
$host   = $ini[$bd]['host'];
$user   = $ini[$bd]['usuario'];
$pass   = $ini[$bd]['senha'];
$port   = $ini[$bd]['porta'];
$versao = $ini[$bd]['versao'];

echo "Tentando conectar ao banco de dados '$bd' em $host:$port<br>";

// Conecta ao banco de dados
$con = mysqli_connect($host, $user, $pass, $bd, $port);
if (!$con) {
    die("Erro na conexão MySQL: " . mysqli_connect_error() . "<br>");
}

echo "Conexão estabelecida com sucesso!<br>";
?>
