var url_ip = host;

$(document).ready(function () {
    // Ativa o evento de clique Validar Empresa
    $('#btn_valida_empresa').on('click', function () {
        // Faz a requisição AJAX
        $.ajax({
            url: 'busca_empresa.php', // Substitua pelo caminho correto
            method: 'GET',
            success: function (response) {
                // Verifica se a resposta é válida
                if (response.length > 0) {
                    // Atualiza o texto do label para "Ok!"
                    // $('#ret_valida_empresa').text('Ok!');

                    // Prepara os dados para o modal
                    let htmlContent = '';
                    response.forEach(empresa => {
                        htmlContent += `
                        <tr>
                            <td>${empresa.id}</td>
                            <td>${empresa.cnpj}</td>
                            <td>${empresa.razaosocial}</td>
                            <td>${empresa.fantasia}</td>
                            <td>${empresa.endereco}</td>
                            <td>${empresa.bairro}</td>
                            <td>${empresa.cidade}/${empresa.estado}</td>
                        </tr>
                        `;
                    });

                    // Insere os dados na tabela do modal
                    $('#modalEmpresaDados').html(htmlContent);

                    // Abre o modal
                    $('#modalEmpresa').modal('show');
                } else {
                    // Atualiza o texto do label caso a resposta seja vazia
                    $('#ret_valida_empresa').text('Nenhum dado encontrado.');
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
                // Exibe mensagem de erro no label
                $('#ret_valida_empresa').text('Erro ao buscar dados.');
            }
        });
    });


    // Validar Usuário
    $('#btn_valida_usuarios').on('click', function () {
        $.ajax({
            url: 'http://' + url_ip + ':9001/sysfood/testa_conexao/loaddatasetevent.php?SQL=SELECT usuario, nome, nomecompleto FROM usuarios',
            method: 'GET',
            success: function (response) {
                // Verifica se há dados no response.RESULT[0]
                if (response.RESULT && response.RESULT[0].length > 0) {
                    // Prepara os dados para o modal
                    let htmlContent = '';
                    response.RESULT[0].forEach(usuario => {
                        htmlContent += `
                                <tr>
                                    <td>${usuario.usuario}</td>
                                    <td>${usuario.nome}</td>
                                    <td>${usuario.nomecompleto}</td>
                                </tr>
                            `;
                    });

                    // Insere os dados na tabela do modal
                    $('#modalDadosUsuario').html(htmlContent);

                    // Abre o modal
                    $('#modalUsuario').modal('show');
                } else {
                    // Atualiza o texto do label caso a resposta seja vazia
                    console.warn('Nenhum dado encontrado.');
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
            }
        });
    });



    // Validar Produtos
    $('#btn_valida_produtos').on('click', function () {
        $.ajax({
            url: 'http://' + url_ip + ':9001/sysfood/testa_conexao/loaddatasetevent.php?SQL=SELECT codigo, gid, cod_barras, desc_reduzida, vl_venda_normal, qtd_atual_estoque FROM produtos LIMIT 15;',
            method: 'GET',
            success: function (response) {
                // Verifica se há dados no response.RESULT[0]
                if (response.RESULT && response.RESULT[0].length > 0) {
                    // Prepara os dados para o modal
                    let htmlContent = '';
                    response.RESULT[0].forEach(produtos => {
                        htmlContent += `
                                <tr>
                                    <td>${produtos.codigo}</td>
                                    <td>${produtos.gid}</td>
                                    <td>${produtos.cod_barras}</td>
                                    <td>${produtos.desc_reduzida}</td>
                                    <td>R$ ${produtos.vl_venda_normal.replace('.', ',')}</td>
                                    <td>${produtos.qtd_atual_estoque}</td>
                                </tr>
                            `;
                    });

                    // Insere os dados na tabela do modal
                    $('#modalDadosProdutos').html(htmlContent);

                    // Abre o modal
                    $('#modalProdutos').modal('show');
                } else {
                    // Atualiza o texto do label caso a resposta seja vazia
                    console.warn('Nenhum dado encontrado.');
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
            }
        });
    });


    // Validar Clientes
    $('#btn_valida_clientes').on('click', function () {
        $.ajax({
            url: 'http://' + url_ip + ':9001/app/loaddatasetevent.php?SQL=SELECT c.codigo, cp.nome_rasocial, cp.endereco, cp.numero, cp.bairro, cp.cidade, cp.estado FROM clientes AS c LEFT JOIN cpessoas AS cp ON cp.gid = c.gidpessoa limit 15;',
            method: 'GET',
            success: function (response) {
                // Verifica se há dados no response.RESULT[0]
                if (response.RESULT && response.RESULT[0].length > 0) {
                    // Prepara os dados para o modal
                    let htmlContent = '';
                    response.RESULT[0].forEach(clientes => {
                        htmlContent += `
                                <tr>
                                    <td>${clientes.codigo}</td>
                                    <td>${clientes.nome_rasocial}</td>
                                    <td>${clientes.endereco}, ${clientes.numero}</td>
                                    <td>${clientes.bairro}</td>
                                    <td>${clientes.cidade} / ${clientes.estado}</td>
                                </tr>
                            `;
                    });

                    // Insere os dados na tabela do modal
                    $('#modalDadosClientes').html(htmlContent);

                    // Abre o modal
                    $('#modalClientes').modal('show');
                } else {
                    // Atualiza o texto do label caso a resposta seja vazia
                    console.warn('Nenhum dado encontrado.');
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro na requisição:', error);
            }
        });
    });
});


// SELECT c.codigo, cp.nome_rasocial, cp.endereco, cp.numero, cp.bairro, cp.cidade, cp.estado FROM clientes AS c LEFT JOIN cpessoas AS cp ON cp.gid = c.gidpessoa limit 15